/*
 * Copyright (c) 2009 Marcus Glocker <marcus@nazgul.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Defines
 */
#define APCD_CONFIG		"/etc/apcd.conf"
#define APCD_MAXRESP		100
#define APCD_QUERY_INT		2	/* UPS query interval in seconds */
#define APCD_LISTEN_PRT		1025	/* default listener port */
#define APCD_LISTEN_CON		1	/* pending client connections */
#define APCD_POLL_FDS		2 + 1	/* maximum clients + listener socket */
#define APCD_POLL_TOUT		10000
#define APCD_REQBUFSIZE		128
#define UPS_STATUS_SHUTDOWN	2
#define UPS_STATUS_ONLINE	8
#define UPS_STATUS_BATTERY	10
#define UPS_STATUS_BOTH		18

struct apcd_config {
	char	device[16];
	char	pidfile[256];
	int	startup_test;
	int	listener;
	double	battery_low;
	double	battery_crit;
	char	trap_battery[256];
	char	trap_online[256];
	char	trap_battery_low[256];
	char	trap_battery_crit[256];
	char	trap_shutdown[256];
};

struct ups_query {
	/* data from UPS */
	double	ups_batcharge;
	double	ups_temp;
	double	ups_load;
	double	ups_linemin;
	double	ups_linemax;
	double	ups_linefreq;
	double	ups_linevolt;
	double	ups_outvolt;
	double	ups_batvolt;
	char	ups_status;

	/* our protocol specific data */
	int	proto_numclients;
};
