/*	$Id: spaceinvaders.h,v 1.3 2017/05/16 17:27:04 hacki Exp $ */

/*
 * Copyright (c) 2017 Marcus Glocker <marcus@nazgul.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Macros.
 */
#define debug_write(a, ...)	DM(a, ...)

/*
 * System.
 */
#define VERSION			"0.1"
#define FILENAME_HISCORE	".spaceinvaders.scores"
#define FILENAME_DEBUG		"spaceinvaders.log"
volatile sig_atomic_t		lock_signal = 0;
int				debug_fd = 0;
extern char			*__progname;

/*
 * Sprites.
 */
#define SPRITES_NUM		15

enum {
	SPACE,
	PLAYER_LASER_BASE,
	PLAYER_LASER,
	SHIELD_3,
	SHIELD_2,
	SHIELD_1,
	INVADER_1,
	INVADER_2,
	INVADER_3,
	INVADER_1_MISSLE,
	INVADER_2_MISSLE,
	INVADER_3_MISSLE,
	MYSTERY_SHIP,
	FLOOR,
	EXPLOSION
};

static const struct sprite {
	char	graph;
	int	score;
	int	damage;
	int	protection;
} sprites[SPRITES_NUM] = {
	{ ' ',  0, 0, 0 },	/* Space */
	{ 'M',  0, 0, 1 },	/* Player base */
	{ '|',  0, 1, 0 },	/* Player laser */
	{ 'X',  0, 0, 3 },	/* Player defense 1 */
	{ 'x',  0, 0, 2 },	/* Player defense 2 */
	{ '_',  0, 1, 1 },	/* Player defense 3 */
	{ 'Y', 30, 0, 1 },	/* Invader 1 */
	{ 'O', 20, 0, 1 },	/* Invader 2 */
	{ 'H', 10, 0, 1 },	/* Invader 3 */
	{ '#',  0, 3, 1 },	/* Invader 1 missle */
	{ '*',  0, 2, 1 },	/* Invader 2 missle */
	{ '.',  0, 1, 1 },	/* Invader 3 missle */
	{ 'T', 50, 0, 1 },	/* Mystery ship */
	{ '-',  0, 0, 0 },	/* Floor */
	{ '@',  0, 0, 0 }	/* Explosion */
};

/*
 * Game board and control.
 */
#define BOARD_ROWS		24
#define BOARD_COLS		80
#define BOARD_UPDATE_USEC	10000
#define INVADERS_MOVE_USEC	1000000
#define INVADERS_MOVE_MIN_USEC	100000
#define INVADERS_SHOT_USEC	1000000
#define INVADERS_MISSLE_USEC	50000
#define PLAYER_LASER_USEC	30000
#define MYSTERY_TRIGGER_USEC	1000000
#define MYSTERY_MOVE_USEC	200000
#define TEXT_CLEANUP_USEC	4000000
#define PAUSE_SEC		3
#define PLAYER_LIVES		3
#define INVADERS_SHOT_MAX	3
#define INVADERS_PER_LINE	11
#define INVADERS_NUM		55
#define SCORE_MAX		9990
#define SCORE_EXTRA_LIVE	1500

enum {
	BBS_BACKUP,
	BBS_RESTORE,
	BBS_REMOVE_INVADERS,
	BBS_REMOVE_INVADERS_MISSLE
};

enum {
	MOVE_PLAYER_LB_RIGHT,
	MOVE_PLAYER_LB_LEFT
};

enum {
	MOVE_INVADERS_RIGHT,
	MOVE_INVADERS_LEFT,
	MOVE_INVADERS_DOWN
};

char board[BOARD_ROWS][BOARD_COLS];
char board_bs[BOARD_ROWS][BOARD_COLS];	/* Board Backing Store */

struct control {
	int	player_score;
	int	player_hiscore;
	int	player_hiscore_new;
	int	player_lives;
	int	player_pos_x;
	int	player_shot_inprogress;
	int	player_laser_cycle;
	int	invaders_num;
	int	invaders_shot_inprogress;
	int	invaders_dir_now;
	int	invaders_dir_last;
	int	invaders_move_cycle;
	int	invaders_move_usec;
	int	invaders_shot_cycle;
	int	invaders_missle_cycle;
	int	mystery_trigger_cycle;
	int	mystery_move_cycle;
	int	mystery_inprogress;
	int	text_cleanup_cycle;
	int	score_extra_live;
	int	game_over;
	int	game_pause;
} ctrl;

/*
 * Texts.
 */
char *text_score = "SCORE";
char *text_hiscore = "HI-SCORE";
char *text_hiscore_new = "NEW HI-SCORE REACHED";
char *text_mystery = "MYSTERY SCORE";
char *text_extra_live = "EXTRA LIVE RECEIVED";
char *text_player_wins = "YOU WIN";
char *text_game_pause = "PAUSE [P = CONTINUE]";
char *text_game_over = "GAME OVER [S = START NEW GAME, Q = QUIT]";
